Triggers = {}

include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/end_trigger")
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/kill_watcher")

Triggers["center_point"] = 
{
	active = false, 
	effect_radius = 20, 
	position = { x = 148.13, y = 115.24, z = 14, f = 1.0}, 
	priority = 1.0, 
	think = "tf_center_point", 
	type = "quest", 
}

Triggers["shammy_quest_stage_03a"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=77.6, x=9.8, z=13.9, f=1 }, 
	priority = 1, 
	think = "tf_shammy_quest_stage_03a", 
	type = "quest", 
}

Triggers["shammy_quest_stage_03b"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=77.6, x=9.8, z=13.9, f=1 }, 
	priority = 1, 
	think = "tf_shammy_quest_stage_03b", 
	type = "quest", 
}	

Triggers["army_set"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=77.6, x=9.8, z=13.9, f=1 }, 
	priority = 1, 
	think = "tf_army_set", 
	type = "quest", 
}

Triggers["campaign"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=-51, x=-40.8, z=4.8, f=1 }, 
	priority = 1, 
	think = "tf_campaign", 
	type = "quest", 
}

Triggers["corp_set"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=77.6, x=9.8, z=13.9, f=1 }, 
	priority = 1, 
	think = "tf_corp_set", 
	type = "quest", 
}

Triggers["on_start"] = 
{
	active = true, 
	effect_radius = 9, 
	position = { y=-39.7, x=-97.1, z=8.6, f=1 }, 
	priority = 1, 
	think = "tf_on_start", 
	type = "quest", 
}

Triggers["relations_vs_army"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=75.3, x=150.5, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_relations_vs_army", 
	type = "quest", 
}

Triggers["shammy_exit_point"] = 
{
	active = true, 
	effect_radius = 6, 
	position = { x = -113.8, y = 119.8, z = 5.1, f = 1.0}, 
	priority = 1.0, 
	think = "tf_shammy_exit_point", 
	type = "quest", 
}

Triggers["shammy_is_going_away"] = 
{
	active = true, 
	effect_radius = 19, 
	position = { y=62, x=-60.6, z=8.2, f=1 }, 
	priority = 1, 
	think = "tf_shammy_is_going_away", 
	type = "quest", 
}

Triggers["shammy_way_out"] = 
{
	color = "0xFF0000", 
	direction = 1, 
	line_dir = 1, 
	patrol_type = "circle", 
	point_count = 3, 
	point_radius = 0.5, 
	position = { x = -77.4, y = 63.8, z = 6.0, f = 1.0}, 
	transfer_mode = "walk", 
	type = "patrol", 
	wait_style = "none", 
	wait_time = 0, 
	patrol_points = {{ x=-77.4369, y=63.8153, z=6.02216},{ x=-95.1204, y=89.8138, z=4.21816},{ x=-114.091, y=119.083, z=5.06831} }
}

Triggers["stop_and_angry"] = 
{
	active = true, 
	effect_radius = 19, 
	position = { y=62, x=-60.6, z=8.2, f=1 }, 
	priority = 1, 
	think = "tf_stop_and_angry", 
	type = "quest", 
}

trigger_functions =
{
tf_shammy_quest_stage_03a = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
		--storyline("shammy_quest_stage_03a")
	end
end,
tf_shammy_quest_stage_03b = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
		--storyline("shammy_quest_stage_03b")
	end
end,
tf_army_set = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
	end
end,
tf_campaign = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
		if ARMY == Sectors.detour_road.owner then
			Triggers["army_set"].active = true
		end	
		if CORP == Sectors.detour_road.owner then
			Triggers["corp_set"].active = true
		end	
	end
end,
tf_corp_set = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
	end
end,
tf_on_start = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		if(trigger_utility.isPlayerPresent(trigger_id,PLAYER) ) then			
			Triggers["campaign"].active = true
			trigger.active = false
		end
	end
end,
tf_relations_vs_army = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
			changeLocalRelations(ENEMY, ARMY)		
			
--			changeLocalRelations(ALLY, "army")		
		trigger.active = false
	end
end,
tf_shammy_exit_point = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		if(trigger_utility.isPersonPresent(trigger_id,"shammy") ) then
			disappear("shammy")
			--storyline("shammy_is_rescued")
			trigger.active = false
		end
	end
end,
tf_shammy_is_going_away = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		if(trigger_utility.delay(trigger_id,2.00) ) then
			log("detour_road", "ATTEMPT TO GO OUT")			
--			Humans["shammy"].behavior = "patrol"
--			Humans["shammy"].patrol_routine = "shammy_way_out"			
			trigger_utility.resetDelay(trigger_id)
--			trigger.active = false
		end	
	end
end,
tf_stop_and_angry = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		if(trigger_utility.isPlayerPresent(trigger_id,PLAYER) ) then
			trigger.active = false
			if Sectors.base.isShammyReadyForSave and ARMY == Sectors.detour_road.owner then
				local result = checkRelations(PLAYER, ARMY)
				if ENEMY ~= result then
					startDlg("stop_and_angry","army_9",CUR_MISSION.Mercs[1])
				end
			end			
		end
	end
end,
--
-- end trigger
--
tf_end_trigger = CommonTriggers.end_trigger,
--
-- kill watcher trigger
--
tf_kill_watcher = CommonTriggers.kill_watcher,
--
-- honey point for bees
--
tf_center_point = CommonTriggers.center_point,
}
